<?php

include_once 'db.php';
include_once 'functions.php';

$db = Database::getInstance();
$link = $db->getConnection();
$functions = new functions();


// ADD SUPPLIER
if (isset($_POST['supp_f_name'])) {
    $name = $_POST['supp_f_name'] . " " . $_POST['supp_l_name'];
    $supp_no = $_POST['supp_no'];
    $address = $_POST['supp_add'];
    $comp_name = $_POST['comp_name'];

    $functions->insert("`suppliers`", "company_name, full_name, contact, address", "'$comp_name', '$name', '$supp_no', '$address'");
}


//GET SUPPLIER
if (isset($_POST['view_suppliers'])) {
    $data = $functions->select('suppliers', '*');
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}


// Get Designations
if (isset($_POST['ViewDesignationTbl'])) {
    $data = $functions->select('designation', '*');
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}

if (isset($_POST['ViewDesignation'])) {
    $data = $functions->select('designation', 'desig');
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}


// Add Designation
if (isset($_POST['saveDesig'])) {
    $saveDesig = $_POST['saveDesig'];
    $functions->insert("`designation`", "desig", "'$saveDesig'");
}


// Add Employee
if (isset($_POST['emp_fname'])) {
    $name = $link->real_escape_string($_POST['emp_fname']) . " " . $link->real_escape_string($_POST['emp_lname']);
    $emp_desig = $link->real_escape_string($_POST['emp_desig']);
    $emp_sal = $link->real_escape_string($_POST['emp_sal']);
    $emp_con = $link->real_escape_string($_POST['emp_con']);
    $emp_cnic = $link->real_escape_string($_POST['emp_cnic']);
    $emp_add = $link->real_escape_string($_POST['emp_add']);

    $functions->insert('employee', '`emp_date`, `emp_name`, `emp_desig`, `emp_sal`, `emp_con`, `emp_cnic`, `emp_add`',
        "NOW() , '$name', '$emp_desig', '$emp_sal', '$emp_con', '$emp_cnic', '$emp_add'");
}


// Get Employees
if (isset($_POST['getEmployees'])) {
    $data = $functions->select('employee', '*');
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}


// Add Designation
if (isset($_POST['stockName'])) {
    $stockName = $_POST['stockName'];
    $functions->insert("`stock_cat`", "`cat_date`, `item_name`", "NOW(), '$stockName'");
}


// Get Categories
if (isset($_POST['getCat'])) {
    $data = $functions->select('stock_cat', '*');
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}

if (isset($_POST['getCategories'])) {
    $data = $functions->select('stock_cat', 'item_name');
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}


// Add Designation
if (isset($_POST['item_name'])) {
    $sel_cat = $link->real_escape_string($_POST['sel_cat']);
    $item_name = $link->real_escape_string($_POST['item_name']);
    $item_price = $link->real_escape_string($_POST['item_price']);

    $functions->insert("`stock_product`", "`stock_date`, `stock_cat`, `stock_name`, `stock_price`", "NOW(), '$sel_cat', '$item_name', '$item_price'");
}


// Get Stock data
if (isset($_POST['getStock'])) {
    $data = $functions->select('stock_product', '*');
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}


// Get supp
if (isset($_POST['getSupp'])) {
    $data = $functions->select('suppliers', 'full_name');
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}


// Get Items
if (isset($_POST['stock_items'])) {
    $data = $functions->select('stock_product', 'stock_name');
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}


// Add Stock
if (isset($_POST['stockDate'])) {
    $stockDate = $link->real_escape_string($_POST['stockDate']);
    $inv_no = strtotime("now");
    $supp_name = $link->real_escape_string($_POST['supp_name']);
    $inv_cat = $link->real_escape_string($_POST['inv_cat']);
    $inv_item = $link->real_escape_string($_POST['inv_item']);
    $stockQty = $link->real_escape_string($_POST['stockQty']);

    $functions->insert("`add_stock`", "`stock_date`, `inv_no`, `supp`, `cat`, `item`, `qty`",
        "'$stockDate', '$inv_no', '$supp_name', '$inv_cat', '$inv_item', '$stockQty'");
}


// Get Stock List
if (isset($_POST['GetStockList'])) {
    $data = $functions->select('add_stock', '*');
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}


// Add Stock
if (isset($_POST['exp_date'])) {
    $exp_date = $link->real_escape_string($_POST['exp_date']);
    $exp_name = $link->real_escape_string($_POST['exp_name']);
    $inv_cat = $link->real_escape_string($_POST['inv_cat']);
    $exp_amount = $link->real_escape_string($_POST['exp_amount']);

    $functions->insert("`expenses`", "`exp_date`, `exp_name`, `exp_desc`, `exp_amount`",
        "'$exp_date', '$exp_name', '$inv_cat', '$exp_amount'");
}


// Fetch expenses
if (isset($_POST['viewExp'])) {
    $data = $functions->select('expenses', '*');
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}
// Search expense
if (isset($_POST['searchExp'])) {
    $data = $_POST['searchExp'];
    $data['startDt'] = $data['startDt'] . ":00";
    $data['endDt'] = $data['endDt'] . ":59";

    $data = $functions->select('expenses', '*', "WHERE (CONCAT(`exp_name`, ' ', `exp_desc`) LIKE '%" . $data['searchInp'] . "%' )");
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}


// Add Sales
if (isset($_POST['getSaleAutoComp'])) {
    $val = $_POST['getSaleAutoComp'];
    if ($val == 'Employee') {
        $data = $functions->select('employee', 'emp_name');
        header('content-type: application/json; charset=utf-8');
        echo json_encode($data);
    }
}

if (isset($_POST['srch_by_id'])) {
    $id = $_POST['srch_by_id'];
    $data = $functions->select('stock_product', 'stock_name, stock_price, stock_cat', "WHERE id = '$id'");
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}

if (isset($_POST['srch_by_name'])) {
    $item = $_POST['srch_by_name'];
    $data = $functions->select('stock_product', 'stock_name, stock_price,stock_cat,id', "WHERE stock_name LIKE '%$item%'");
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}

if (isset($_POST['grandTotal'])) {
    $sale_id = isset($_POST['sale_id']) ? $_POST['sale_id'] : 0;
    $sale_cat = $_POST['sale_cat'];
    $acc_name = $_POST['acc_name'];
    $grandTotal = $_POST['grandTotal'];
    $DiscAmount = $_POST['DiscAmount'];
    $DlvCharge = $_POST['DlvCharge'];
    $salePercent = $_POST['salePercent'];
    $PayableAmount = $_POST['PayableAmount'];
    $saleDesc = $_POST['saleDesc'];
    $balAmount = $_POST['balAmount'];
    $recAmount = $_POST['recAmount'];

    $sale_item = $_POST['sale_item']; #array
    $salePrice = $_POST['salePrice']; #array
    $saleQty = $_POST['saleQty']; #array
    $saleTotal = $_POST['saleTotal']; #array

    if ($sale_id < 1) {
        $functions->insert("`sales`", "sale_cat, acc_name, sale_grand, sale_dis, sale_am, sale_payable, received, balance, dlvry_chrgs, `desc`",
            "'$sale_cat', '$acc_name', '$grandTotal', '$DiscAmount', '$salePercent', '$PayableAmount', '$recAmount', '$balAmount', '$DlvCharge', '$saleDesc'");

        $sale_id = $link->insert_id;
    } else {
        $link->query("DELETE FROM `sales` WHERE id='" . $sale_id . "' ");
        $link->query("DELETE FROM `sale_details` WHERE sale_id='" . $sale_id . "' ");

        $functions->insert("`sales`", "id, sale_cat, acc_name, sale_grand, sale_dis, sale_am, sale_payable, received, balance, dlvry_chrgs, `desc`",
            "'$sale_id', '$sale_cat', '$acc_name', '$grandTotal', '$DiscAmount', '$salePercent', '$PayableAmount', '$recAmount', '$balAmount', '$DlvCharge', '$saleDesc'");
    }

    echo $sale_id;

    for ($i = 0; $i < count($saleTotal); $i++) {
        $functions->insert("`sale_details`", "sale_id, item_id, item_price, item_qty", "'$sale_id', '$sale_item[$i]', '$salePrice[$i]', '$saleQty[$i]'");
    }
}


if (isset($_POST['deleteSale'])) {
    $sale_id = $_POST['deleteSale'];

    $resp['MsgType'] = 'Done';
    $resp['Msg'] = 'Record deleted successfully.';

    $q = $link->query("DELETE FROM `sales` WHERE id='" . $sale_id . "' ");
    if ($q) {
        $q2 = $link->query("DELETE FROM `sale_details` WHERE sale_id='" . $sale_id . "' ");
        if ( ! $q2) {
            $resp['MsgType'] = 'Error';
            $resp['Msg'] = 'Unable to delete sale records now.';
        }
    } else {
        $resp['MsgType'] = 'Error';
        $resp['Msg'] = 'Unable to delete sales now.';
    }

    $data = $functions->select('sales', 'id, sale_date, sale_cat, acc_name, sale_grand, sale_dis, dlvry_chrgs, received, balance');
    header('content-type: application/json; charset=utf-8');
    echo json_encode($resp);
}

if (isset($_POST['saleRecord'])) {
    $toDate = date('Y-m-d');
    $where = " WHERE sale_date BETWEEN '" . $toDate . " 00:00:00' AND '" . $toDate . " 23:59:59' " ;
    $data = $functions->select('sales', 'id, sale_date, sale_cat, acc_name, sale_grand, sale_dis, dlvry_chrgs, received, balance', $where);
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}

// Fetch sale for Edit/Update
if (isset($_POST['fetchSale'])) {
    $sales_id = $_POST['fetchSale'];

    $q = "SELECT * FROM `sales` WHERE id='" . $sales_id . "' ";
    $qResp = $link->query($q);
    if ($qResp->num_rows > 0) {
        $array = array();
        while ($row = $qResp->fetch_assoc()) {
            $array[] = $row;
        }

        $q2 = "SELECT sale_details.item_id, sale_details.item_price, sale_details.item_qty, stock_product.stock_cat, stock_product.stock_name FROM sale_details
        INNER JOIN stock_product ON (sale_details.item_id = stock_product.id) WHERE sale_details.sale_id = " . $sales_id;
        $qResp2 = $link->query($q2);
        if ($qResp2->num_rows > 0) {
            while ($row2 = $qResp2->fetch_assoc()) {
                $array[0]['items'][] = $row2;
            }

        }

        header('content-type: application/json; charset=utf-8');
        echo json_encode($array);
        return;
    } else {
        header('content-type: application/json; charset=utf-8');
        echo json_encode('error:' . $link->error);
        return;
    }
}


if (isset($_POST['searchSales'])) {
    $data = $_POST['searchSales'];
    $data['startDt'] = $data['startDt'] . ":00";
    $data['endDt'] = $data['endDt'] . ":59";

    $saleWhere = $data != null ? ' WHERE (`acc_name` LIKE "%' . $data['searchInp'] . '%") AND (sale_date BETWEEN "' . $data['startDt'] . '" AND "' . $data['endDt'] . '")' : "";

    $data = $functions->select('sales', 'id, sale_date, sale_cat, acc_name, sale_grand, sale_dis, dlvry_chrgs, received, balance', $saleWhere . "ORDER BY id DESC");
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}


if (isset($_POST['saleReport'])) {
    $saleReport = $_POST['saleReport'];

    $data = $functions->select('sales', 'acc_name', "WHERE balance > 0 AND sale_cat = '$saleReport' GROUP BY acc_name ASC");
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}


if (isset($_POST['saleAccReport'])) {
    $acc_name = $_POST['saleAccReport'];

    $data = $functions->select('sales', 'acc_name,`desc`,sale_date,sum(sale_grand),sum(sale_dis) sale_dis,sum(sale_grand - sale_dis),sum(received),sum(balance)', "WHERE balance > 0 AND acc_name = '$acc_name' GROUP BY acc_name");

    /*$data = $functions->select('sales','id,`desc`,sale_date,sale_grand,sale_dis,(sale_grand - sale_dis),received,balance', "WHERE balance > 0 AND acc_name = '$acc_name'");*/
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}

// ADD SUPPLIER
if (isset($_POST['updSaleBal'])) {
    $data = $_POST['updSaleBal'];
    $acc_name = $data['acc_name'];
    $received = $data['received'];
    unset($data['modalID']);
    unset($data['acc_name']);
    unset($data['saleAmt']);
    unset($data['sale_dis']);
    unset($data['desc']);
    unset($data['balance']);
    $qryError = array();
    $qryStmnt = array();

    //print_r($data); echo $acc_name ." - ". $received; exit();

    $fetSaleWithBalQ = $functions->select("sales", "`id`,`received`,`balance`", "WHERE acc_name='$acc_name' AND balance > 0 ORDER BY id ");
    //print_r($fetSaleWithBalQ); exit();

    if ($fetSaleWithBalQ != 'error:' AND !empty($fetSaleWithBalQ)) {
        foreach ($fetSaleWithBalQ as $balItems) {
            $rowID = $balItems['id'];
            $rowBal = $balItems['balance'];
            $rowRcvd = $balItems['received'];

            if ($received > 0) {
                if ($received <= $rowBal) {
                    $newBal = ($rowBal - $received);
                    $rowRcvd += $received;
                    $received = 0;
                } else {
                    $newBal = 0;
                    $rowRcvd += $rowBal;
                    $received -= $rowBal;
                }

                $updData = array("received" => $rowRcvd, "balance" => $newBal);
                $q = $functions->update('sales', $updData, "id='$rowID'");
                $qryError[] = $q->Error;
                $qryStmnt[] = $q->Qry;
            }
        }
    }

    if ($q->MsgType == 'Done') {
        $jsonData = array(
            "MsgType" => "Done",
            "Msg" => "Balance updated.",
            "qryError" => $qryError,
            "qryStmnt" => $qryStmnt,
        );
    } else {
        $jsonData = array(
            "MsgType" => "Done",
            "Msg" => "Balance updated.",
            "Error" => $q->Error,
            "Qry" => $q->Qry
        );
    }
    header('content-type: application/json; charset=utf-8');
    echo json_encode($jsonData);
}

// Fetch summary view data
function fetSummary($data = null)
{
    global $link;
    $expToatal = 0;
    $catToatal = 0;
    $catDisc = 0;
    $totDisc = 0;
    $totBal = 0;
    $onAccTotal = 0;
    $itemTotal = array();
    $htmlResp = '';
    $searchInptSale = '';
    $searchInptExp = '';
    $searchInptOnAcc = '';

    if (isset($data['searchInp']) AND !empty($data['searchInp'])) {
        $searchInptSale = '(`stock_product`.`stock_name` LIKE "%' . $data['searchInp'] . '%") AND';
        $searchInptExp = '(exp_name LIKE "%' . $data['searchInp'] . '%" OR exp_desc LIKE "%' . $data['searchInp'] . '%") AND';
        $searchInptOnAcc = '(acc_name LIKE "%' . $data['searchInp'] . '%") AND';
    }


    $saleWhere = $data != null ? ' WHERE ' . $searchInptSale . ' (sales.sale_date BETWEEN "' . $data['startDt'] . '" AND "' . $data['endDt'] . '")' : "";
    $saleDiscWhere = $data != null ? ' WHERE (sale_date BETWEEN "' . $data['startDt'] . '" AND "' . $data['endDt'] . '")' : "";
    $expWhere = $data != null ? 'WHERE ' . $searchInptExp . ' (exp_date BETWEEN "' . $data['startDt'] . '" AND "' . $data['endDt'] . '")' : "";
    $onAccWhere = $data != null ? 'AND ' . $searchInptOnAcc . ' (sale_date BETWEEN "' . $data['startDt'] . '" AND "' . $data['endDt'] . '")' : "";

    $itemsTotaStmnt = "SELECT item_id, SUM(item_qty) qty, SUM(item_price * item_qty) amt FROM sale_details GROUP BY item_id";
    $itemsTotaQ = $link->query($itemsTotaStmnt);
    if ($itemsTotaQ->num_rows > 0) {
        while ($itemsTotaFet = $itemsTotaQ->fetch_assoc()) {
            $itemTotal[$itemsTotaFet['item_id']] = (object)array("qty" => $itemsTotaFet['qty'], "amt" => $itemsTotaFet['amt']);
        }
    } else {
        $htmlResp = '<div class="row Summarry_nav"><div class="col-md-12">No sales found</div></div>';
        $jsonData = array(
            "MsgType" => "Done",
            "Msg" => "",
            "htmlResp" => $htmlResp,
            "qStmnt" => $itemsTotaStmnt
        );
        header('content-type: application/json; charset=utf-8');
        echo json_encode($jsonData);
        exit();
    }

    /*, `sale_details`.`item_qty` qty*/
    /*, `sale_details`.`item_price` * `sale_details`.`item_qty` amt*/
    $qStmnt = "SELECT `stock_product`.`stock_cat` cat, `stock_product`.`stock_name` item, `sale_details`.`item_id` item_id, `sale_details`.`sale_id` sale_id, SUM(`sale_details`.`item_qty`) qty, SUM(`sale_details`.`item_price` * `sale_details`.`item_qty`) val
                FROM `norani`.`sale_details`
                    INNER JOIN `norani`.`sales` ON (`sale_details`.`sale_id` = `sales`.`id`)
                    INNER JOIN `norani`.`stock_product` ON (`sale_details`.`item_id` = `stock_product`.`id`)
                $saleWhere
                GROUP BY item ORDER BY cat,item ASC";

    $expQ = $link->query("SELECT exp_name,exp_desc,exp_amount FROM expenses " . $expWhere);
    $onAccQ = $link->query("SELECT acc_name,sale_date,balance FROM sales WHERE balance > 0 $onAccWhere");
    $discQ = $link->query("SELECT sum(sale_dis) saleDisc FROM sales " . $saleDiscWhere);
    if ($discQ->num_rows > 0) {
        $discArr = $discQ->fetch_assoc();
        $totDisc = $discArr['saleDisc'];
    }

    $q = $link->query($qStmnt);
    if ($q->num_rows > 0) {
        $fetArr = $q->fetch_all();
        $htmlResp = '<div class="row Summarry_nav"><div class="col-md-12">Sales</div></div>';

        $catArr = array();
        $cnt = 0;
        $catToatal = 0;
        $catDisc = 0;
        $totBal = 0;
        foreach ($fetArr as $row) {
            foreach ($row as $key => $item) {
                if ($key == 0 AND !in_array($item, $catArr)) {
                    if ($cnt != 0) {
                        $htmlResp .= '<div class="row Summarry_itemName">
                                            <div class="col-md-12">
                                                <div class="col-md-1 col-md-offset-9 text-right">' . number_format($catToatal, 2, ".", ",") . '</div>
                                                <div class="col-md-1 text-right"></div>
                                                <div class="col-md-1 text-right">' . number_format($totBal, 2, ".", ",") . '</div>
                                            </div>
                                        </div>';
                    }
                    $catToatal = 0;

                    $htmlResp .= '<div class="row Summarry_Cat"><div class="col-md-11 col-md-offset-1">' . $item . '</div></div>
                                        <div class="row">
                                                <div class="col-md-8 col-md-offset-1 Summarry_item">
                                                    <div class="col-md-6 col-md-offset-1 ">Item name</div>
                                                    <div class="col-md-2 text-center">Qty</div>
                                                    <div class="col-md-3 text-right">Amount</div>
                                                </div>
                                        </div>';
                    array_push($catArr, $item);
                } else if ($key == 1) {
                    $htmlResp .= '<div class="row Summarry_itemName">
                                    <div class="col-md-8 col-md-offset-1">
                                        <div class="col-md-6 col-md-offset-1">' . $item . '</div>';
                }
                if ($data == null) {
                    if ($key == 2) {
                        $htmlResp .= '<div class="col-md-2 text-center">' . $itemTotal[$item]->qty . '</div>
                            <div class="col-md-3 text-right">' . number_format($itemTotal[$item]->amt, 2, ".", ",") . '</div></div></div>';
                        $catToatal += $itemTotal[$item]->amt;
                        $totBal += $itemTotal[$item]->amt;
                    }
                } else {
                    if ($key == 4) {
                        $htmlResp .= '<div class="col-md-2 text-center">' . $item . '</div>';
                    }
                    if ($key == 5) {
                        $htmlResp .= '<div class="col-md-3 text-right">' . number_format($item, 2, ".", ",") . '</div></div></div>';

                        $catToatal += $item;
                        $totBal += $item;
                    }
                }
                /*else if ($key == 3){
                    $saleIDArr[] = $item;
                }*/
            }
            $cnt++;
        }

        $htmlResp .= '<div class="row Summarry_itemName">
                                        <div class="col-md-12">
                                                <div class="col-md-1 col-md-offset-9 text-right">' . number_format($catToatal, 2, ".", ",") . '</div>
                                                <div class="col-md-1 text-right"></div>
                                                <div class="col-md-1 text-right">' . number_format($totBal, 2, ".", ",") . '</div>
                                            </div>
                                        </div>';

        $htmlResp .= '<div class="row Summarry_Cat"><div class="col-md-11 col-md-offset-1">Sale Discount</div></div>
                                        <div class="row">
                                                <div class="col-md-8 col-md-offset-1 Summarry_item">
                                                    <div class="col-md-6 col-md-offset-1 ">Item name</div>
                                                    <div class="col-md-2 text-center">Qty</div>
                                                    <div class="col-md-3 text-right">Amount</div>
                                                </div>
                                        </div>';

        $htmlResp .= '<div class="row Summarry_itemName">
                                                <div class="col-md-8 col-md-offset-1">
                                                    <div class="col-md-6 col-md-offset-1 ">Total sale discount</div>
                                                    <div class="col-md-2 text-center"></div>
                                                    <div class="col-md-3 text-right">' . number_format($totDisc, 2, ".", ",") . '</div>
                                                </div>
                                        <div class="col-md-12">
                                                <div class="col-md-1 col-md-offset-9 text-right"></div>
                                                <div class="col-md-1 text-right">' . number_format($totDisc, 2, ".", ",") . '</div>
                                                <div class="col-md-1 text-right">' . number_format($totBal - $totDisc, 2, ".", ",") . '</div>
                                            </div>
                                        </div>';
    }
    if ($expQ->num_rows > 0) {
        $fetExpArr = $expQ->fetch_all();
        $expToatal = 0;

        $htmlResp .= '<div class="row Summarry_Expnav"><div class="col-md-12">Expenses</div></div>';
        $htmlResp .= '<div class="row Summarry_Cat"><div class="col-md-11 col-md-offset-1">Expenses</div></div>
                                        <div class="row">
                                            <div class="col-md-8 col-md-offset-1 Summarry_item">
                                                <div class="col-md-6 col-md-offset-1">Name</div>
                                                <div class="col-md-3 col-md-offset-2 text-right">Amount</div>
                                            </div>
                                        </div>';
        foreach ($fetExpArr as $row) {
            foreach ($row as $key => $item) {
                if ($key == 0) {
                    $htmlResp .= '<div class="row Summarry_itemName"><div class="col-md-8 col-md-offset-1"><div class="col-md-6 col-md-offset-1">' . $item;
                } else if ($key == 1) {
                    $htmlResp .= ' (' . $item . ')</div>';
                } else if ($key == 2) {
                    $htmlResp .= '<div class="col-md-3 col-md-offset-2 text-right">' . number_format($item, 2, ".", ",") . '</div></div></div>';
                    $expToatal += $item;
                }
            }
        }
        $htmlResp .= '<div class="row Summarry_itemName">
                            <div class="col-md-12">
                                <div class="col-md-1 col-md-offset-9 text-right"></div>
                                <div class="col-md-1 text-right">' . number_format($expToatal, 2, ".", ",") . '</div>
                                <div class="col-md-1 text-right"></div>
                            </div>
                        </div>';
    }
    if ($onAccQ->num_rows > 0) {
        $fetOnAccArr = $onAccQ->fetch_all();
        $onAccTotal = 0;

        $htmlResp .= '<div class="row Summarry_Expnav"><div class="col-md-12">Account Receivables</div></div>';
        $htmlResp .= '<div class="row Summarry_Cat"><div class="col-md-11 col-md-offset-1">Sales on Account</div></div>
                                        <div class="row">
                                            <div class="col-md-8 col-md-offset-1 Summarry_item">
                                                <div class="col-md-6 col-md-offset-1">Name</div>
                                                <div class="col-md-3 col-md-offset-2 text-right">Amount</div>
                                            </div>
                                        </div>';
        foreach ($fetOnAccArr as $row) {
            foreach ($row as $key => $item) {
                if ($key == 0) {
                    $htmlResp .= '<div class="row Summarry_itemName"><div class="col-md-8 col-md-offset-1"><div class="col-md-6 col-md-offset-1">' . $item;
                } else if ($key == 1) {
                    $htmlResp .= ' (' . $item . ')</div>';
                } else if ($key == 2) {
                    $htmlResp .= '<div class="col-md-3 col-md-offset-2 text-right">' . number_format($item, 2, ".", ",") . '</div></div></div>';
                    $onAccTotal += $item;
                }
            }
        }
        $htmlResp .= '<div class="row Summarry_itemName">
                            <div class="col-md-12">
                                <div class="col-md-1 col-md-offset-9 text-right"></div>
                                <div class="col-md-1 text-right"></div>
                                <div class="col-md-1 text-right">' . number_format($onAccTotal, 2, ".", ",") . '</div>
                            </div>
                        </div>';
    }

    $prof = $totBal - $expToatal > 0 ? $totBal - ($totDisc + $expToatal + $onAccTotal) : 0;
    $loss = $totBal - $expToatal < 0 ? $totBal - ($totDisc + $expToatal + $onAccTotal) : 0;
    $htmlResp .= '<div class="row Summarry_Totalnav"><div class="col-md-12">Total Income</div></div>
                        <div class="row Summarry_Totalhead text-center">
                             <div class="col-md-12">
                                <div class="col-md-2">Total Sales</div>
                                <div class="col-md-2">Total Sale Discount</div>
                                <div class="col-md-2">Total Expences</div>
                                <div class="col-md-2">Total Receivables</div>
                                <div class="col-md-2">Cash in Hand</div>
                                <div class="col-md-2">Net Loss</div>
                            </div>
                        </div>
                        <div class="row Summarry_TotalBody text-center">
                            <div class="col-md-12">
                                <div class="col-md-2">' . number_format($totBal, 2, ".", ",") . '</div>
                                <div class="col-md-2">' . number_format($totDisc, 2, ".", ",") . '</div>
                                <div class="col-md-2">' . number_format($expToatal, 2, ".", ",") . '</div>
                                <div class="col-md-2">' . number_format($onAccTotal, 2, ".", ",") . '</div>
                                <div class="col-md-2 text-success" style="font-size:1.3em">' . number_format($prof, 2, ".", ",") . '</div>
                                <div class="col-md-2 text-danger">' . number_format($loss, 2, ".", ",") . '</div>
                            </div>
                        </div>';

    $jsonData = array(
        "MsgType" => "Done",
        "Msg" => "",
        "qStmnt" => $qStmnt,
        "itemTotal" => $itemTotal,
        "htmlResp" => $htmlResp
    );
    header('content-type: application/json; charset=utf-8');
    echo json_encode($jsonData);
}

if (isset($_POST['saleSummary'])) {
    fetSummary();
}
if (isset($_POST['searchSumm'])) {
    $data = $_POST['searchSumm'];
    $data['startDt'] = $data['startDt'] . ":00";
    $data['endDt'] = $data['endDt'] . ":59";

    fetSummary($data);
}


//secrch engine sales
if (isset($_POST['SaleAccEmployee'])) {
    $acc_name = $_POST['SaleAccEmployee'];
    $srchDateFrom = $_POST['srchDateFrom'];
    $srchDateTo = $_POST['srchDateTo'];

    $data = $functions->select('sales', 'id,`desc`,sale_date,sale_grand,sale_dis,(sale_grand - sale_dis),received,balance', "WHERE acc_name = '$acc_name' AND (sale_date BETWEEN '$srchDateFrom:00' AND '$srchDateTo:59')");
    header('content-type: application/json; charset=utf-8');
    echo json_encode($data);
}


$link->close();