/*
SQLyog Ultimate v11.11 (64 bit)
MySQL - 5.6.11 : Database - norani
*********************************************************************
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`norani` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `norani`;

/*Table structure for table `add_stock` */

DROP TABLE IF EXISTS `add_stock`;

CREATE TABLE `add_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_date` date NOT NULL,
  `inv_no` int(11) NOT NULL,
  `supp` varchar(225) NOT NULL,
  `cat` varchar(225) NOT NULL,
  `item` varchar(225) NOT NULL,
  `qty` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

/*Data for the table `add_stock` */

insert  into `add_stock`(`id`,`stock_date`,`inv_no`,`supp`,`cat`,`item`,`qty`) values (1,'2016-04-30',1462032005,'Kami','Fast Food','Zinger',50),(2,'2016-05-08',1462686728,'Kami','Fast Food','Chicken Crispy Roll',150),(3,'2016-05-18',1463518285,'Shah G','Fast Food','Chicken Broast Qtr',40);

/*Table structure for table `designation` */

DROP TABLE IF EXISTS `designation`;

CREATE TABLE `designation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `desig` varchar(225) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;

/*Data for the table `designation` */

insert  into `designation`(`id`,`desig`) values (5,'Manager'),(6,'Bar B Q Chef'),(7,'Bar B Q Chef Assistant'),(8,'Roll Chef'),(9,'Fast Food Chef'),(10,'Fast Food Chef Assistant'),(11,'Chinese Food Chef'),(12,'Karahi Chef'),(13,'Birani Exporter'),(14,'Naan Chef'),(15,'Naan Chef Assistant'),(16,'Chapati Chef'),(17,'Paratha Chef'),(18,'Delivery Man'),(19,'Waiter');

/*Table structure for table `employee` */

DROP TABLE IF EXISTS `employee`;

CREATE TABLE `employee` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_date` date NOT NULL,
  `emp_name` varchar(225) NOT NULL,
  `emp_desig` varchar(225) NOT NULL,
  `emp_sal` int(11) NOT NULL,
  `emp_con` varchar(15) NOT NULL,
  `emp_cnic` varchar(15) NOT NULL,
  `emp_add` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;

/*Data for the table `employee` */

insert  into `employee`(`id`,`emp_date`,`emp_name`,`emp_desig`,`emp_sal`,`emp_con`,`emp_cnic`,`emp_add`) values (4,'2016-05-09','Saif / Table # ','Waiter',600,'02134980869','4210197659879','Gulsahn E Iqbal'),(5,'2016-05-09','Muhammad Zakaria','Paratha Chef',600,'03111834450','3130366613487','Sohrab Goth'),(6,'2016-05-06','Ismail / table #','Waiter',300,'03428194485','4220132543545','Pib Colony'),(7,'2016-05-09','sardar Shakoor','Waiter',600,'03113911436','4220186349209','Golden Town'),(8,'2016-05-09','Muhammad Touseef','Waiter',400,'03113911436','4220186349209','Golden Town'),(9,'2016-05-09','Ali Raza','Waiter',400,'0000','11111','1111'),(10,'2016-05-07','Adnan Bhatti','Bar B Q Chef',900,'03033890499','4440486847177','Liaquatabad'),(11,'2016-06-05','Abdul Hameed','Bar B Q Chef',800,'03012323157','42101','Gizri'),(12,'2016-06-10','Muhammad Abid','Roll',45000,'03012694177','3630109406131','Shanti Nagar'),(13,'2016-06-13','Aman','Waiter',500,'03060263387','123','Zia Colony'),(14,'2016-06-13','Baba Zulfi','Waiter',600,'123','123','sss'),(15,'2016-08-18','Rafique','Waiter',12000,'03062130334','1350394622677','Sabzi Mandi'),(16,'2016-08-24','Ahsan Ali','Manager',0,'03077944043','1111111','Gulshan'),(17,'2016-09-21','M Noman','Waiter',12000,'03145364180','3740592530397','Model Colony'),(19,'2017-04-01','Momoo / table #','Waiter',400,'111111','111111','Karachi'),(20,'2017-04-27','M.faheem','Waiter',400,'03467468974','8210178067445','Lalokhait Dakhana'),(21,'2017-04-27','Muzammil','Waiter',400,'03471256776','8240154171565','Neepa'),(22,'2017-04-30','M.Asif','Waiter',400,'03442382469','1350328438071','Neepa'),(23,'2017-05-18','Mazhar / table #','Waiter',400,'03451248261','4210166136477','Phar Ganj'),(24,'2017-05-26','saleem / table #','Waiter',400,'03323431007','42101','Naseera abad'),(25,'2017-06-02','Watoo / table #','Waiter',400,'0311','0414','Neepa'),(26,'2017-07-08','Furrukh Tikka','Bar B Q Chef',1300,'03212371019','42101','Shahfaisal'),(27,'2017-07-08','Mazhar Hussain','Bar B Q Chef',1200,'03002644452','3630139316389','Kausar Niazi Colony'),(28,'2017-08-29','Rameez Raja','Waiter',400,'11','11','shashfaisal'),(29,'2017-08-29','Imtiaz Bhai','Waiter',400,'11','11','Saifi College');

/*Table structure for table `expenses` */

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `exp_name` varchar(225) NOT NULL,
  `exp_desc` text NOT NULL,
  `exp_amount` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=402 DEFAULT CHARSET=latin1;

/*Data for the table `expenses` */

insert  into `expenses`(`id`,`exp_date`,`exp_name`,`exp_desc`,`exp_amount`) values (3,'2017-09-06 20:00:00','SUGAR','Daily Expense',150),(4,'2017-09-06 20:00:00','koyla','Daily Expense',1200),(5,'2017-09-06 20:00:00','ahsan dish wash','Daily Expense',330),(7,'2017-09-06 20:00:00','qayoom','Daily Expense',1800),(8,'2017-09-06 20:00:00','rizwan','Daily Expense',13000),(9,'2017-09-06 20:00:00','Dehari','Daily Expense',12000),(10,'2017-09-06 20:00:00','tanweer','Daily Expense',250),(12,'2017-09-07 20:00:00','coffe','Daily Expense',150),(14,'2017-09-07 20:00:00','home','Daily Expense',230),(15,'2017-09-07 20:00:00','adnan','Daily Expense',2000),(16,'2017-09-07 20:00:00','pepsi bill','Daily Expense',19215),(17,'2017-09-07 20:00:00','koyla','Daily Expense',1200),(18,'2017-09-07 20:00:00','daal','Daily Expense',200),(19,'2017-09-07 20:00:00','dish wash','Daily Expense',330),(20,'2017-09-07 20:00:00','set','Daily Expense',700),(22,'2017-09-07 20:00:00','rizwan','Daily Expense',13000),(23,'2017-09-07 20:00:00','labour dehari','Daily Expense',12000),(24,'2017-09-08 21:00:00','tanweer','Daily Expense',60),(26,'2017-09-08 21:00:00','FRIES','Daily Expense',1500),(28,'2017-09-08 21:00:00','cheese','Daily Expense',4500),(29,'2017-09-08 21:00:00','medicen','Daily Expense',525),(30,'2017-09-08 21:00:00','zakaria','Daily Expense',200),(31,'2017-09-08 21:00:00','qayoom','Daily Expense',2300),(32,'2017-09-08 21:00:00','KOYLAY','Daily Expense',1200),(33,'2017-09-08 21:00:00','RIZWAN','Daily Expense',13000),(34,'2017-09-08 21:00:00','MUBEEN','Daily Expense',1000),(35,'2017-09-08 21:00:00','PAKWAIUSTAAD','Daily Expense',3160),(36,'2017-09-08 21:00:00','DEHARI LABOUR','dAILY eXPENSE',13000),(37,'2017-09-09 16:00:00','shakoor','daily expense',5000),(38,'2017-09-09 16:00:00','baraf','daily expense',240),(39,'2017-09-09 16:00:00','fries','daily expense',1500),(40,'2017-09-09 16:00:00','zakaria','daily expense',500),(41,'2017-09-09 16:00:00','IMTIAZ','daily expense',2000),(42,'2017-09-09 16:00:00','BROAST','daily expense',2850),(43,'2017-09-09 16:00:00','ABID','daily expense',200),(44,'2017-09-09 16:00:00','KOYLAY','daily expense',1200),(45,'2017-09-09 16:00:00','QAYOOM','daily expense',1600),(46,'2017-09-09 16:00:00','RIZWAN','daily expense',13000),(47,'2017-09-09 16:00:00','Dehari','daily expense',13000),(48,'2017-09-10 16:00:00','abid','daily expense',150),(49,'2017-09-10 16:00:00','zakaria','daily expense',300),(50,'2017-09-10 16:00:00','bangali','daily expense',100),(53,'2017-09-10 16:00:00','pepsi bill','daily expense',14620),(54,'2017-09-10 16:00:00','broast','daily expense',2850),(55,'2017-09-10 16:00:00','NAEEM','daily expense',400),(56,'2017-09-10 16:00:00','koylay','daily expense',1200),(57,'2017-09-10 16:00:00','RIZWAN','daily expense',13000),(58,'2017-09-10 16:00:00','QAYOOM','daily expense',2200),(59,'2017-09-10 16:00:00','dEHARI lABOUR','daily expense',13000),(61,'2017-09-11 16:00:00','bangali','daily expense',100),(62,'2017-09-11 16:00:00','abid','daily expense',150),(63,'2017-09-11 16:00:00','baraf','daily expense',320),(64,'2017-09-11 16:00:00','home','daily expense',100),(66,'2017-09-11 16:00:00','zakaria','daily expense',200),(67,'2017-09-11 16:00:00','mubeen','daily expense',1000),(68,'2017-09-11 16:00:00','broast','daily expense',2940),(69,'2017-09-11 16:00:00','doodh','daily expense',50000),(70,'2017-09-11 16:00:00','koylay','daily expense',1200),(71,'2017-09-11 16:00:00','qayoom','daily expense',3850),(72,'2017-09-11 16:00:00','sadiq','daily expense',860),(73,'2017-09-11 16:00:00','imran malik','daily expense',360),(74,'2017-09-11 16:00:00','rizwan','daily expense',13000),(75,'2017-09-11 16:00:00','Dehari labour','daily expense',13000),(76,'2017-09-11 16:00:00','Demand','daily expense',5170),(77,'2017-09-12 21:00:00','koyla','Daily Expense',1200),(78,'2017-09-12 21:00:00','abid masala','Daily Expense',200),(79,'2017-09-12 21:00:00','mobeen','Daily Expense',2000),(80,'2017-09-12 21:00:00','broast','Daily Expense',2765),(81,'2017-09-12 21:00:00','qayoom','Daily Expense',1900),(82,'2017-09-12 21:00:00','Rizwan','Daily Expense',13000),(83,'2017-09-12 21:00:00','dEHARI LABOUR','Daily Expense',13000),(84,'2017-09-13 16:00:00','zakaria','daily expense',300),(85,'2017-09-13 16:00:00','pepsi bill','daily expense',13650),(86,'2017-09-13 16:00:00','bun','daily expense',2040),(87,'2017-09-13 16:00:00','adnan','daily expense',2000),(88,'2017-09-13 16:00:00','fries','daily expense',2000),(89,'2017-09-13 16:00:00','dimand','daily expense',5000),(90,'2017-09-13 16:00:00','shakoor','daily expense',5000),(91,'2017-09-13 16:00:00','imtiaz','daily expense',2000),(92,'2017-09-13 16:00:00','abid','daily expense',150),(93,'2017-09-13 16:00:00','adnan','daily expense',300),(94,'2017-09-13 16:00:00','broast','daily expense',2700),(95,'2017-09-13 16:00:00','koyla','daily expense',1200),(96,'2017-09-13 16:00:00','faheem beef','daily expense',12800),(97,'2017-09-13 16:00:00','qayoom','daily expense',2100),(98,'2017-09-13 16:00:00','fast food','daily expense',600),(99,'2017-09-13 16:00:00','rizwan','daily expense',13000),(100,'2017-09-14 16:00:00','nestle water','daily expense',19740),(101,'2017-09-14 16:00:00','bun wala','daily expense',1050),(102,'2017-09-14 16:00:00','chini pati','daily expense',150),(103,'2017-09-14 16:00:00','lunch','daily expense',200),(104,'2017-09-14 16:00:00','mannan','daily expense',1000),(105,'2017-09-14 16:00:00','shahid','daily expense',12000),(106,'2017-09-14 16:00:00','fries','daily expense',1500),(107,'2017-09-14 16:00:00','daal','daily expense',200),(108,'2017-09-14 16:00:00','chini sooji','daily expense',200),(109,'2017-09-14 16:00:00','bacha','daily expense',330),(110,'2017-09-14 16:00:00','arshad','daily expense',100),(111,'2017-09-14 16:00:00','waheed','daily expense',2000),(112,'2017-09-14 16:00:00','fast food','daily expense',600),(113,'2017-09-14 16:00:00','bangali fast food','daily expense',1500),(114,'2017-09-14 16:00:00','rizwan','daily expense',13000),(115,'2017-09-14 16:00:00','doodh wala','daily expense',300),(116,'2017-09-14 16:00:00','anis ustad','daily expense',1400),(117,'2017-09-14 16:00:00','yasir','daily expense',400),(118,'2017-09-14 16:00:00','zikriya','daily expense',800),(119,'2017-09-14 16:00:00','aqib','daily expense',700),(120,'2017-09-14 16:00:00','arshad','daily expense',900),(121,'2017-09-14 16:00:00','abid karahi','daily expense',900),(122,'2017-09-14 16:00:00','chapati wala','daily expense',1200),(123,'2017-09-14 16:00:00','shakoor','daily expense',600),(124,'2017-09-14 16:00:00','imtiaz','daily expense',400),(125,'2017-09-15 16:00:00','baraf','daily expense',240),(126,'2017-09-15 16:00:00','pakola bill','daily expense',4050),(127,'2017-09-15 16:00:00','faheem','daily expense',7200),(128,'2017-09-15 16:00:00','imtiaz','daily expense',2000),(129,'2017-09-15 16:00:00','chini pati','daily expense',150),(130,'2017-09-15 16:00:00','guard','daily expense',100),(131,'2017-09-15 16:00:00','boast','daily expense',2700),(132,'2017-09-15 16:00:00','koyla','daily expense',1200),(133,'2017-09-15 16:00:00','bangali fast food','daily expense',1500),(134,'2017-09-15 16:00:00','fries','daily expense',1500),(135,'2017-09-15 16:00:00','rizwan','daily expense',13000),(136,'2017-09-16 16:00:00','koyla','daily expense',1200),(137,'2017-09-16 16:00:00','broast','daily expense',5100),(138,'2017-09-16 16:00:00','waheed','daily expense',1400),(139,'2017-09-16 16:00:00','bangali fast food','daily expense',1500),(140,'2017-09-16 16:00:00','fast food','daily expense',600),(141,'2017-09-16 16:00:00','qayoom','daily expense',2500),(142,'2017-09-16 16:00:00','rizwan','daily expense',13000),(143,'2017-09-16 16:00:00','arshad','daily expense',1000),(144,'2017-09-16 16:00:00','anis ustad','daily expense',1920),(145,'2017-09-16 16:00:00','yasir','daily expense',200),(146,'2017-09-16 16:00:00','aqib','daily expense',700),(147,'2017-09-16 16:00:00','zakir','daily expense',800),(148,'2017-09-16 16:00:00','abid karahi','daily expense',900),(149,'2017-09-16 16:00:00','abid karahi','daily expense',200),(150,'2017-09-16 16:00:00','naan wala','daily expense',700),(151,'2017-09-16 16:00:00','chapati wala','daily expense',1300),(152,'2017-09-16 16:00:00','guard','daily expense',200),(153,'2017-09-16 16:00:00','shakoor','daily expense',600),(154,'2017-09-16 16:00:00','imtiaz','daily expense',400),(155,'2017-09-16 16:00:00','adnan','daily expense',2000),(156,'2017-09-16 16:00:00','mannan','daily expense',1000),(157,'2017-09-16 16:00:00','doodh wala','daily expense',40000),(158,'2017-09-17 17:00:00','koyla','daily expense',1200),(159,'2017-09-17 17:00:00','abid masala','daily expense',50),(160,'2017-09-17 17:00:00','fries','daily expense',1300),(161,'2017-09-17 17:00:00','pepsi bill','daily expense',16100),(162,'2017-09-17 17:00:00','bacha','daily expense',330),(163,'2017-09-17 17:00:00','daal','daily expense',200),(164,'2017-09-17 17:00:00','waheed','daily expense',1400),(165,'2017-09-17 17:00:00','qayoom','daily expense',3750),(166,'2017-09-17 17:00:00','abid roll','daily expense',15000),(167,'2017-09-17 17:00:00','rizwan','daily expense',13000),(168,'2017-09-17 17:00:00','adnan','daily expense',2000),(169,'2017-09-17 17:00:00','kohla','daily expense',55000),(170,'2017-09-17 17:00:00','dehari','daily expense',11000),(171,'2017-09-18 16:00:00','home','daily expense',150),(172,'2017-09-18 16:00:00','zikriya','daily expense',150),(173,'2017-09-18 16:00:00','adnan','daily expense',2000),(174,'2017-09-18 16:00:00','fries','daily expense',2000),(175,'2017-09-18 16:00:00','mobeen','daily expense',2000),(176,'2017-09-18 16:00:00','broast','daily expense',2400),(177,'2017-09-18 16:00:00','toti','daily expense',500),(178,'2017-09-18 16:00:00','koyla','daily expense',1200),(179,'2017-09-18 16:00:00','rizwan','daily expense',13000),(180,'2017-09-18 16:00:00','qayoom','daily expense',6000),(181,'2017-09-18 16:00:00','doodh wala','daily expense',400),(182,'2017-09-18 16:00:00','dehari','daily expense',13000),(183,'2017-09-19 16:00:00','waheed','daily expense',100),(184,'2017-09-19 16:00:00','waheed','daily expense',100),(185,'2017-09-19 16:00:00','dimand','daily expense',8000),(186,'2017-09-19 16:00:00','mannan','daily expense',1000),(187,'2017-09-19 16:00:00','lunch','daily expense',200),(188,'2017-09-19 16:00:00','kohla','daily expense',10000),(189,'2017-09-19 16:00:00','imtiaz','daily expense',4000),(190,'2017-09-19 16:00:00','chini pati','daily expense',150),(191,'2017-09-19 16:00:00','pepsi bill','daily expense',13100),(192,'2017-09-19 16:00:00','kohla','daily expense',4000),(193,'2017-09-19 16:00:00','faheem','daily expense',6800),(194,'2017-09-19 16:00:00','fries','daily expense',1750),(195,'2017-09-19 16:00:00','adnan','daily expense',2000),(196,'2017-09-19 16:00:00','koyla','daily expense',1200),(197,'2017-09-19 16:00:00','set','daily expense',2000),(198,'2017-09-19 16:00:00','khula','daily expense',1000),(199,'2017-09-19 16:00:00','qayoom','daily expense',4000),(200,'2017-09-19 16:00:00','rizwan','daily expense',13000),(201,'2017-09-19 16:00:00','dehari','daily expense',13000),(202,'2017-09-20 16:00:00','abid masala','daily expense',150),(203,'2017-09-20 16:00:00','arshad','daily expense',500),(204,'2017-09-20 16:00:00','bun wala','daily expense',1600),(205,'2017-09-20 16:00:00','bar bq masala','daily expense',9500),(206,'2017-09-20 16:00:00','mannan','daily expense',1000),(207,'2017-09-20 16:00:00','ice','daily expense',320),(208,'2017-09-20 16:00:00','dimand','daily expense',7500),(209,'2017-09-20 16:00:00','adnan','daily expense',2000),(210,'2017-09-20 16:00:00','fries','daily expense',2000),(211,'2017-09-20 16:00:00','BROAST','daily expense',2500),(212,'2017-09-20 16:00:00','SURF','daily expense',50),(213,'2017-09-20 16:00:00','QAYOOM','daily expense',3300),(214,'2017-09-20 16:00:00','RIZWAN','daily expense',13000),(215,'2017-09-20 16:00:00','DEHARI','daily expense',13000),(216,'2017-09-21 16:00:00','bun wala','daily expense',1680),(217,'2017-09-21 16:00:00','car pentre','daily expense',1000),(218,'2017-09-21 16:00:00','mannan','daily expense',1000),(219,'2017-09-21 16:00:00','pepsi bill','daily expense',6400),(220,'2017-09-21 16:00:00','zakkir paratha','daily expense',200),(221,'2017-09-21 16:00:00','surf','daily expense',200),(222,'2017-09-21 16:00:00','lunch','daily expense',200),(223,'2017-09-21 16:00:00','pakola bill','daily expense',4050),(224,'2017-09-21 16:00:00','ice','daily expense',240),(225,'2017-09-21 16:00:00','chini pati','daily expense',150),(226,'2017-09-21 16:00:00','adnan','daily expense',2000),(227,'2017-09-21 16:00:00','koyla','daily expense',1150),(228,'2017-09-21 16:00:00','doodh wala','daily expense',40000),(229,'2017-09-21 16:00:00','broast','daily expense',2580),(230,'2017-09-21 16:00:00','Qayoom','daily expense',5500),(231,'2017-09-21 16:00:00','rizwan','daily expense',13000),(232,'2017-09-21 16:00:00','dehari','daily expense',13000),(233,'2017-09-22 17:00:00','fries','Daily Expense',2300),(234,'2017-09-22 17:00:00','bu wala','Daily Expense',1500),(235,'2017-09-22 17:00:00','dimand','Daily Expense',2300),(236,'2017-09-22 17:00:00','nestle water','Daily Expense',20135),(237,'2017-09-22 17:00:00','ustad asgar','Daily Expense',2000),(238,'2017-09-22 17:00:00','shahid benor','Daily Expense',800),(239,'2017-09-22 17:00:00','paratha saman','Daily Expense',500),(240,'2017-09-22 17:00:00','adnan','Daily Expense',2000),(241,'2017-09-22 17:00:00','faheem','Daily Expense',3200),(242,'2017-09-22 17:00:00','koyla','Daily Expense',1150),(243,'2017-09-22 17:00:00','broast','Daily Expense',2700),(244,'2017-09-22 17:00:00','Qayoom','Daily Expense',3500),(245,'2017-09-22 17:00:00','petrol','daily expense',100),(246,'2017-09-22 17:00:00','rizwan','daily expense',13000),(247,'2017-09-22 17:00:00','dehari','daily expense',13000),(248,'2017-09-23 17:00:00','bun wala','Daily expense',1500),(249,'2017-09-23 17:00:00','lunch','Daily expense',200),(250,'2017-09-23 17:00:00','mannan','Daily expense',1000),(251,'2017-09-23 17:00:00','ice','Daily expense',320),(252,'2017-09-23 17:00:00','scotch bright','Daily expense',200),(253,'2017-09-23 17:00:00','adnan','Daily expense',2000),(254,'2017-09-23 17:00:00','fries','Daily expense',2000),(255,'2017-09-23 17:00:00','paratha saman','Daily expense',200),(256,'2017-09-23 17:00:00','mobin','Daily expense',3000),(257,'2017-09-23 17:00:00','Qayoom','Daily expense',4700),(258,'2017-09-23 17:00:00','rizwan','Daily expense',13000),(259,'2017-09-23 17:00:00','dehari','Daily expense',14500),(260,'2017-09-23 17:00:00','molvi','Daily expense',18000),(261,'2017-09-24 16:00:00','bun wala','daily expense',2000),(262,'2017-09-24 16:00:00','lunch','daily expense',200),(263,'2017-09-24 16:00:00','dimand','daily expense',3500),(264,'2017-09-24 16:00:00','manan','daily expense',1000),(265,'2017-09-24 16:00:00','chini','daily expense',200),(266,'2017-09-24 16:00:00','ice','daily expense',320),(267,'2017-09-24 16:00:00','adnan','daily expense',2000),(268,'2017-09-24 16:00:00','fries','daily expense',2000),(269,'2017-09-24 16:00:00','daal methi','daily expense',200),(270,'2017-09-24 16:00:00','broast','daily expense',2520),(271,'2017-09-24 16:00:00','Qayoom','daily expense',3200),(272,'2017-09-24 16:00:00','rizwan','daily expense',13000),(273,'2017-09-24 16:00:00','rizwan','daily expense',13000),(274,'2017-09-24 16:00:00','dehari','daily expense',1500),(275,'2017-09-25 17:00:00','chini pati','Daily Expense',150),(276,'2017-09-25 17:00:00','adnan','Daily Expense',2000),(277,'2017-09-25 17:00:00','bun wala','Daily Expense',1500),(278,'2017-09-25 17:00:00','pepsi bill','Daily Expense',14000),(279,'2017-09-25 17:00:00','lunch','Daily Expense',200),(280,'2017-09-25 17:00:00','arshad','Daily Expense',150),(281,'2017-09-25 17:00:00','dimand','Daily Expense',5500),(282,'2017-09-25 17:00:00','manan','Daily Expense',1000),(283,'2017-09-25 17:00:00','adnan','Daily Expense',2000),(284,'2017-09-25 17:00:00','fries','Daily Expense',2000),(285,'2017-09-25 17:00:00','koyla','Daily Expense',1150),(286,'2017-09-25 17:00:00','faheem','Daily Expense',2000),(287,'2017-09-25 17:00:00','broast','Daily Expense',3100),(288,'2017-09-25 17:00:00','Qayoom','Daily Expense',7500),(289,'2017-09-25 17:00:00','Qayoom','Daily Expense',200),(290,'2017-09-25 17:00:00','Rizwan','Daily Expense',13000),(291,'2017-09-25 17:00:00','Dehari','Daily Expense',14500),(292,'2017-09-26 17:00:00','bun wala','Daily Expense',1500),(293,'2017-09-26 17:00:00','manan','Daily Expense',1000),(294,'2017-09-26 17:00:00','shahid','Daily Expense',100),(295,'2017-09-26 17:00:00','ice','Daily Expense',320),(296,'2017-09-26 17:00:00','chini','Daily Expense',150),(297,'2017-09-26 17:00:00','chini sooji','Daily Expense',300),(298,'2017-09-26 17:00:00','fries','Daily Expense',2000),(299,'2017-09-26 17:00:00','toti','Daily Expense',1000),(300,'2017-09-26 17:00:00','Medicine','Daily Expense',770),(301,'2017-09-26 17:00:00','koyla','Daily Expense',1150),(302,'2017-09-26 17:00:00','bread','Daily Expense',200),(303,'2017-09-26 17:00:00','broast','Daily Expense',2560),(304,'2017-09-26 17:00:00','doodh wala','Daily Expense',45000),(305,'2017-09-26 17:00:00','adnan','Daily Expense',2000),(306,'2017-09-26 17:00:00','Qayoom','Daily Expense',7000),(307,'2017-09-26 17:00:00','Rizwan','Daily Expense',13000),(308,'2017-09-26 17:00:00','Dehari','Daily Expense',14500),(309,'2017-09-27 21:00:00','MAITHI','Daily Expense',50),(310,'2017-09-27 21:00:00','PARATHA','Daily Expense',200),(311,'2017-09-27 21:00:00','Adnan','Daily Expense',2000),(312,'2017-09-27 21:00:00','fRIES','Daily Expense',2000),(313,'2017-09-27 21:00:00','dAAL','Daily Expense',180),(314,'2017-09-27 21:00:00','Faheem','Daily Expense',4400),(315,'2017-09-27 21:00:00','Vegi','Daily Expense',8800),(316,'2017-09-27 21:00:00','Guard','Daily Expense',50),(317,'2017-09-27 21:00:00','Koila','Daily Expense',1150),(318,'2017-09-27 20:00:00','Dehari','Daily Expense',13550),(319,'2017-09-27 20:00:00','Chitta','Daily Expense',360),(320,'2017-09-28 20:00:00','Pepsi','Daily Expense',25580),(321,'2017-09-28 20:00:00','Cream','Daily Expense',1000),(322,'2017-09-28 20:00:00','Fries','Daily Expense',2000),(323,'2017-09-28 20:00:00','koila','Daily Expense',1150),(324,'2017-09-28 20:00:00','Broast','Daily Expense',2660),(325,'2017-09-28 20:00:00','rizwan','Daily Expense',13000),(326,'2017-09-28 20:00:00','Dehari','Daily Expense',14000),(327,'2017-09-29 20:00:00','Till','Daily Expense',90),(328,'2017-09-29 20:00:00','Home','Daily Expense',260),(329,'2017-09-29 20:00:00','Home saman','Daily Expense',316),(330,'2017-09-29 20:00:00','Fries','Daily Expense',2000),(331,'2017-09-29 20:00:00','sogi chini','Daily Expense',200),(332,'2017-09-29 20:00:00','abid','Daily Expense',50),(333,'2017-09-29 20:00:00','Broast','Daily Expense',2690),(334,'2017-09-29 20:00:00','QAYOOM','Daily Expense',6000),(335,'2017-09-29 20:00:00','dEHARI','Daily Expense',13350),(336,'2017-09-30 20:00:00','Surf','Daily Expense',100),(337,'2017-09-30 20:00:00','fries','Daily Expense',1400),(338,'2017-09-30 20:00:00','broast','Daily Expense',2625),(339,'2017-09-30 20:00:00','Koila','Daily Expense',1150),(340,'2017-09-30 20:00:00','bun','Daily Expense',200),(341,'2017-09-30 20:00:00','rizwan','Daily Expense',13000),(342,'2017-09-30 20:00:00','Dehari','Daily Expense',13500),(343,'2017-10-01 20:00:00','Manan','Daily Expense',1000),(344,'2017-10-01 20:00:00','ice','Daily Expense',320),(345,'2017-10-01 20:00:00','ABID','Daily Expense',30),(346,'2017-10-01 20:00:00','fries','Daily Expense',2000),(347,'2017-10-01 20:00:00','Dehari','Daily Expense',12350),(348,'2017-10-01 20:00:00','Rizwan','Daily Expense',13000),(349,'2017-10-02 21:00:00','masala','daily expense',50),(350,'2017-10-02 21:00:00','chini','daily expense',120),(351,'2017-10-02 21:00:00','daal','daily expense',180),(352,'2017-10-02 21:00:00','broast','daily expense',2635),(353,'2017-10-02 21:00:00','adnan','daily expense',2000),(354,'2017-10-02 21:00:00','Dehari','daily expense',13500),(355,'2017-10-03 20:00:00','paratha','Daily Expense',200),(356,'2017-10-03 20:00:00','masala','Daily Expense',85),(357,'2017-10-03 20:00:00','Match Box','Daily Expense',30),(358,'2017-10-03 20:00:00','Baba','Daily Expense',50),(359,'2017-10-03 20:00:00','Adnan','Daily Expense',2000),(360,'2017-10-03 20:00:00','Faheem','Daily Expense',4800),(361,'2017-10-03 20:00:00','Koila','Daily Expense',1800),(362,'2017-10-03 20:00:00','Broast','Daily Expense',2520),(363,'2017-10-03 20:00:00','Rizwan','Daily Expense',13000),(364,'2017-10-03 20:00:00','Dehari labour','Daily Expense',12850),(365,'2017-10-04 21:00:00','Cheeni Pati','Daily Expense',150),(366,'2017-10-04 21:00:00','Koila','Daily Expense',1150),(367,'2017-10-04 21:00:00','Broast','Daily Expense',2645),(368,'2017-10-04 21:00:00','faheem','Daily Expense',5400),(369,'2017-10-04 21:00:00','Bun','Daily Expense',500),(370,'2017-10-04 21:00:00','Rizwan','Daily Expense',13000),(371,'2017-10-04 21:00:00','Adnan','Daily Expense',2000),(372,'2017-10-04 21:00:00','Labour','Daily Expense',12050),(373,'2017-10-05 19:00:00','Partha','Daily Expense',80),(374,'2017-10-05 19:00:00','masala','Daily Expense',50),(375,'2017-10-05 19:00:00','KOILA','Daily Expense',1150),(376,'2017-10-05 19:00:00','uNCLE','Daily Expense',14500),(377,'2017-10-05 19:00:00','bROAST','Daily Expense',2680),(378,'2017-10-05 19:00:00','qayoom','Daily Expense',8500),(379,'2017-10-05 19:00:00','baloons','Daily Expense',50),(380,'2017-10-05 19:00:00','rizwan','Daily Expense',13000),(381,'2017-10-05 19:00:00','Rizwan','Daily Expense',100),(382,'2017-10-05 19:00:00','Dehari Labour','Daily Expense',13850),(383,'2017-10-06 20:00:00','tanweer','Daily Expense',30000),(384,'2017-10-06 20:00:00','Imran Bill','Daily Expense',720),(385,'2017-10-06 20:00:00','Chicken','Daily Expense',1700),(386,'2017-10-06 20:00:00','Home','Daily Expense',1300),(387,'2017-10-06 20:00:00','Home medicine','Daily Expense',1150),(388,'2017-10-06 20:00:00','Shahid bhai','Daily Expense',2000),(389,'2017-10-06 20:00:00','Koila','Daily Expense',1150),(390,'2017-10-06 20:00:00','qayoom','Daily Expense',4700),(391,'2017-10-06 20:00:00','rizwan','Daily Expense',13000),(392,'2017-10-06 20:00:00','Dehari','Daily Expense',13500),(393,'2017-10-07 16:00:00','ADNAN','daily expense',2000),(394,'2017-10-07 16:00:00','KOYLA','daily expense',1150),(395,'2017-10-07 16:00:00','BROAST','daily expense',2520),(396,'2017-10-07 16:00:00','SAJU','daily expense',1700),(397,'2017-10-07 16:00:00','Qayoom','daily expense',6500),(398,'2017-10-07 16:00:00','Qayoom','daily expense',200),(399,'2017-10-07 16:00:00','Bun','daily expense',480),(400,'2017-10-07 16:00:00','Medicine','daily expense',300),(401,'2017-10-07 16:00:00','Naeem','daily expense',100);

/*Table structure for table `sale_details` */

DROP TABLE IF EXISTS `sale_details`;

CREATE TABLE `sale_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sale_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `item_price` int(11) NOT NULL,
  `item_qty` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

/*Data for the table `sale_details` */

insert  into `sale_details`(`id`,`sale_id`,`item_id`,`item_price`,`item_qty`) values (1,1,12,110,12),(2,2,3,110,4),(3,3,2,100,4),(4,4,2,100,4),(5,5,4,140,4),(6,6,4,140,4),(7,7,2,100,4);

/*Table structure for table `sales` */

DROP TABLE IF EXISTS `sales`;

CREATE TABLE `sales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sale_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `sale_cat` varchar(225) NOT NULL,
  `acc_name` varchar(225) NOT NULL,
  `sale_grand` int(11) NOT NULL,
  `sale_dis` int(11) NOT NULL,
  `dlvry_chrgs` int(11) NOT NULL,
  `received` int(11) NOT NULL,
  `balance` int(11) NOT NULL,
  `sale_am` int(11) NOT NULL,
  `sale_payable` int(11) NOT NULL,
  `desc` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

/*Data for the table `sales` */

insert  into `sales`(`id`,`sale_date`,`sale_cat`,`acc_name`,`sale_grand`,`sale_dis`,`dlvry_chrgs`,`received`,`balance`,`sale_am`,`sale_payable`,`desc`) values (1,'2018-03-23 14:26:38','Customer','',1320,0,0,1320,0,0,1320,''),(2,'2018-03-23 14:38:35','Customer','',440,0,0,440,0,0,440,''),(3,'2018-03-23 14:38:54','Customer','',400,0,0,400,0,0,400,''),(4,'2018-03-23 14:42:52','Customer','',400,0,0,400,0,0,400,''),(5,'2018-03-23 14:46:06','Customer','',560,0,0,560,0,0,560,''),(6,'2018-03-23 14:52:52','Customer','',560,0,0,560,0,0,560,''),(7,'2018-03-23 14:55:59','Customer','',400,0,0,400,0,0,400,'');

/*Table structure for table `stock_cat` */

DROP TABLE IF EXISTS `stock_cat`;

CREATE TABLE `stock_cat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_date` date NOT NULL,
  `item_name` varchar(225) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

/*Data for the table `stock_cat` */

insert  into `stock_cat`(`id`,`cat_date`,`item_name`) values (1,'2016-04-30','Fast Food'),(2,'2016-04-30','Bar B Q'),(3,'2016-04-30','Chinese'),(4,'2016-04-30','Roll'),(5,'2016-04-30','Karahi'),(6,'2016-04-30','Naan'),(7,'2016-04-30','Paratha'),(8,'2016-04-30','Chapati'),(9,'2016-04-30','Biryani'),(14,'2016-04-30','Deserts'),(15,'2016-05-01','Extras');

/*Table structure for table `stock_product` */

DROP TABLE IF EXISTS `stock_product`;

CREATE TABLE `stock_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_date` date NOT NULL,
  `stock_cat` varchar(225) NOT NULL,
  `stock_name` varchar(225) NOT NULL,
  `stock_price` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=198 DEFAULT CHARSET=latin1;

/*Data for the table `stock_product` */

insert  into `stock_product`(`id`,`stock_date`,`stock_cat`,`stock_name`,`stock_price`) values (1,'0000-00-00','Bar B Q','Chicken Crispy Roll',180),(2,'0000-00-00','Bar B Q','Chicken Chatni Roll',100),(3,'0000-00-00','Bar B Q','Chicken Garlic Mayo Roll',110),(4,'0000-00-00','Bar B Q','Chicken Mayo Cheese Roll',140),(5,'0000-00-00','Bar B Q','Chicken Behari Chatni Roll',100),(6,'0000-00-00','Bar B Q','Chicken Chilli Garlic Roll',120),(7,'0000-00-00','Bar B Q','Chicken Malai Chatni Roll',110),(8,'0000-00-00','Bar B Q','Chicken Malai Garlic Mayo',120),(9,'0000-00-00','Bar B Q','Chicken Malai Cheese Roll',140),(10,'0000-00-00','Bar B Q','Chicken Malai Behari Roll',110),(11,'0000-00-00','Bar B Q','Chicken Reshmi Kabab Chatni Roll',100),(12,'0000-00-00','Bar B Q','Chicken Reshmi Kabab Mayo Roll',110),(13,'0000-00-00','Bar B Q','Chicken Reshmi Kabab Cheese Roll',130),(14,'0000-00-00','Bar B Q','Chicken Reshmi Kabab Chatpata Roll',100),(15,'0000-00-00','Bar B Q','Beef Boti Roll',100),(16,'0000-00-00','Bar B Q','Beef Boti Mayo Roll',110),(17,'0000-00-00','Bar B Q','Beef Boti Mayo Cheese Roll',140),(18,'0000-00-00','Bar B Q','Beef Boti Chatpata Roll',110),(19,'0000-00-00','Bar B Q','Beef Boti Chilli Garlic Roll',120),(20,'0000-00-00','Bar B Q','Beef Kabab Chatni Roll',100),(21,'0000-00-00','Bar B Q','Beef Kabab Mayo Roll',110),(22,'0000-00-00','Bar B Q','Beef Kabab Cheese Roll',130),(23,'0000-00-00','Bar B Q','Beef Kabab Chatpata Roll',110),(24,'0000-00-00','Bar B Q','Beef Kabab Chilli Garlic Roll',120),(25,'0000-00-00','Fast Food','Chicken Broast Qtr',190),(26,'0000-00-00','Fast Food','Chicken Broast Half',380),(27,'0000-00-00','Fast Food','Chicken Broast Full',750),(28,'0000-00-00','Fast Food','Chicken Broast Crispy',220),(29,'0000-00-00','Fast Food','Chicken Burger',140),(30,'0000-00-00','Fast Food','Chicken Cheese Burger',170),(31,'0000-00-00','Fast Food','Chicken Big Burger',220),(32,'0000-00-00','Fast Food','Chicken Big Cheese Burger',250),(33,'0000-00-00','Fast Food','Chicken Zinger Burger',180),(34,'0000-00-00','Fast Food','Chicken Zinger Cheese Burger',210),(35,'0000-00-00','Fast Food','Beef Burger',140),(36,'0000-00-00','Fast Food','Beef Cheese Burger',170),(37,'0000-00-00','Fast Food','Beef Jumbo Burger',220),(38,'0000-00-00','Fast Food','Beef Jumbo Cheese Burger',250),(39,'0000-00-00','Fast Food','Chicken Sandwich',170),(40,'0000-00-00','Fast Food','Club Sandwich',180),(41,'0000-00-00','Fast Food','Bar.B.Q Sandwich',280),(42,'0000-00-00','Fast Food','Fries Regular',70),(43,'0000-00-00','Bar B Q','Chicken Tikka (Chest)',160),(44,'0000-00-00','Bar B Q','Chicken Tikka Green',180),(45,'0000-00-00','Bar B Q','Chicken Behari Tikka',180),(46,'0000-00-00','Bar B Q','Chicken Behari Boneless Plate',240),(47,'0000-00-00','Bar B Q','Chicken Malai Tikka',180),(48,'0000-00-00','Bar B Q','Chicken Boti Plate',220),(49,'0000-00-00','Bar B Q','Chicken Malai Boti Plate',280),(50,'0000-00-00','Bar B Q','Beef Boti Plate',200),(51,'0000-00-00','Bar B Q','Seekh Kabab Plate',220),(52,'0000-00-00','Bar B Q','Beef Behari Boti Plate',200),(53,'0000-00-00','Bar B Q','Chicken Reshmi Kabab Plate',240),(54,'0000-00-00','Bar B Q','Gola Kabab Plate',220),(55,'0000-00-00','Karahi','Chicken Karahi',800),(56,'0000-00-00','Karahi','Chicken Karahi Green',900),(57,'0000-00-00','Karahi','Chicken Karahi Achar',900),(58,'0000-00-00','Karahi','Chicken Karahi White',1000),(59,'0000-00-00','Karahi','Chicken Handi',1200),(60,'0000-00-00','Biryani','Chicken Qorma',140),(61,'0000-00-00','Karahi','Mutton Karahi',1400),(62,'0000-00-00','Karahi','Mutton Karahi Achar',1400),(63,'0000-00-00','Karahi','Mutton Karahi Brown',1400),(64,'0000-00-00','Karahi','Mutton Karahi White',1500),(65,'0000-00-00','Biryani','Chicken Biryani (Single)',120),(66,'0000-00-00','Biryani','Beef Pulao (Single)  ',160),(67,'0000-00-00','Extras','Doodh Dulari',80),(68,'0000-00-00','Extras','Zarda Special',60),(69,'0000-00-00','Extras','Kheer',60),(70,'0000-00-00','Bar B Q','Puri Paratha (Large)',40),(71,'0000-00-00','Chapati','Chapati',10),(72,'0000-00-00','Extras','Raita',30),(73,'0000-00-00','Bar B Q','Salad',50),(74,'0000-00-00','Naan','Naan',12),(75,'0000-00-00','Extras','Cold Drink (Regular)',30),(76,'0000-00-00','Extras','Mineral Water (Small)',30),(77,'0000-00-00','Extras','Mineral Water (Large)',60),(78,'0000-00-00','Extras','Cane',50),(79,'0000-00-00','Chinese','Chicken Corn Soup',70),(80,'0000-00-00','Chinese','Hot & Sour Soup (White)',90),(81,'0000-00-00','Chinese','Chicken VegetableSoup',90),(82,'0000-00-00','Chinese','Chicken Thai Soup',90),(83,'0000-00-00','Chinese','Chicken Yakhni Soup',80),(84,'0000-00-00','Chinese','Chicken Noodles Soup',90),(85,'0000-00-00','Chinese','Chicken Shashlaik (Gravy)',90),(86,'0000-00-00','Chinese','Chicken Munchurian (Gravy)',80),(87,'0000-00-00','Chinese','Chicken Chilli Dry',90),(88,'0000-00-00','Chinese','Chicken Jalfrezi (Gravy)',200),(89,'0000-00-00','Chinese','Chicken Chilli Vegetable (Gravy)',200),(90,'0000-00-00','Chinese','Chicken Ginger',200),(91,'0000-00-00','Chinese','Sweat & Sour (Gravy)',170),(92,'0000-00-00','Chinese','Chicken Shashlik With Rice',280),(93,'0000-00-00','Chinese','Chicken Munchurian With Rice',280),(94,'0000-00-00','Chinese','Chicken Chiili Dry With Rice',280),(95,'0000-00-00','Chinese','Chicken Jalfrezi With Rice',280),(96,'0000-00-00','Chinese','Chicken Chiili Vegi With Rice',280),(97,'0000-00-00','Chinese','Chicken Ginger With Rice',280),(98,'0000-00-00','Chinese','Chicken Chowmein',250),(99,'0000-00-00','Chinese','Vegi Chowmein',250),(100,'0000-00-00','Chinese','',160),(101,'0000-00-00','Chinese','',250),(102,'0000-00-00','Chinese','',250),(103,'0000-00-00','Chinese','',250),(104,'0000-00-00','Chinese','',250),(105,'0000-00-00','Chinese','',250),(106,'0000-00-00','Chinese','',250),(107,'0000-00-00','Chinese','',250),(108,'0000-00-00','Chinese','',270),(109,'0000-00-00','Chinese','',270),(110,'0000-00-00','Chinese','',250),(111,'0000-00-00','Chinese','',250),(112,'0000-00-00','Chinese','',250),(113,'0000-00-00','Chinese','',250),(114,'0000-00-00','Chinese','',250),(115,'0000-00-00','Chinese','',250),(116,'0000-00-00','Chinese','',250),(117,'0000-00-00','Chinese','',340),(118,'0000-00-00','Chinese','',330),(119,'0000-00-00','Chinese','',330),(120,'0000-00-00','Chinese','',350),(121,'0000-00-00','Chinese','Chicken Chowmein',180),(122,'0000-00-00','Chinese','Mix Chowmein (B & C)',230),(123,'0000-00-00','Chinese','Vegi Chowmein (B & C)',150),(124,'0000-00-00','Chinese','Beef Chilli Chowmein',200),(125,'0000-00-00','Chinese','Prawn Chowmein',280),(126,'0000-00-00','Chinese','Chicken Masala Rice',185),(127,'0000-00-00','Chinese','Egg Fried Rice',150),(128,'0000-00-00','Chinese','Vegi Fried Rice',150),(129,'0000-00-00','Chinese','Chicken Fried Rice',200),(130,'0000-00-00','Chinese','Garlic Fried Rice',135),(131,'0000-00-00','Chinese','Singaporian Fried Rice',170),(132,'0000-00-00','Chinese','Prawn Fried Rice',220),(133,'0000-00-00','Fast Food','Fries Large',100),(134,'0000-00-00','Biryani','Biryani Small',100),(135,'0000-00-00','Biryani','Biryani Small',80),(136,'0000-00-00','Biryani','Biryani Small',60),(137,'0000-00-00','Biryani','Chicken Biryani Double',230),(138,'0000-00-00','Biryani','Beef Biryani',150),(139,'0000-00-00','Biryani','Beef Biryani Double',280),(140,'0000-00-00','Biryani','Chicken Biryani 1Kg.',300),(141,'0000-00-00','Biryani','Pulao small',100),(142,'0000-00-00','Biryani','Pulao small',80),(143,'0000-00-00','Biryani','Pulao small',60),(144,'0000-00-00','Biryani','Beef Pulao Double',280),(145,'0000-00-00','Biryani','Chicken Pulao',150),(146,'0000-00-00','Biryani','Beef Pulao 1Kg.',400),(147,'0000-00-00','Bar B Q','Puri Paratha (small)',30),(148,'0000-00-00','Naan','Kulcha',12),(149,'0000-00-00','Naan','Till Naan',15),(150,'0000-00-00','Naan','Garlic Naan',20),(151,'0000-00-00','Naan','Roghni Naan',20),(152,'0000-00-00','Extras','Cold Drink (500ml)',50),(153,'0000-00-00','Extras','Cold Drink (500ml) Sting',60),(154,'0000-00-00','Extras','Cold Drink (1.5 L)',90),(155,'0000-00-00','Extras','Cold Drink (2.15 L)',120),(156,'0000-00-00','Extras','Cold Drink (2.5 L)',130),(157,'0000-00-00','Extras','Slice Juice',20),(158,'0000-00-00','Extras','Pakola Juice',35),(159,'0000-00-00','Extras','Nestle Juice',35),(160,'0000-00-00','Extras','Rani Juice',60),(161,'0000-00-00','Fast Food','Cheese Slice',30),(162,'0000-00-00','Fast Food','Dinner Roll',15),(170,'2016-05-09','Biryani','Biryani V(Small)',50),(171,'2016-05-10','Fast Food','Deal 1',920),(172,'2016-05-10','Bar B Q','Deal 2',550),(173,'2016-05-10','Bar B Q','Deal 3',320),(174,'2016-05-10','Bar B Q','Deal 4',400),(175,'2016-05-10','Fast Food','Deal 5',520),(176,'2016-05-10','Bar B Q','Deal 7',790),(177,'2016-05-10','Bar B Q','Deal 8',490),(178,'2016-05-10','Bar B Q','Deal 6',1050),(179,'2016-05-10','Extras','Raita (S)',20),(180,'2016-05-27','Bar B Q','Chicken Boti Seekh',110),(181,'2016-05-27','Bar B Q','Chicken malai Boti Seekh',140),(182,'2016-05-28','Bar B Q','Beef Boti Seekh',100),(183,'2016-05-28','Bar B Q','Seekh Kabab Seekh',110),(184,'2016-05-28','Bar B Q','Beef Behari Seekh',100),(185,'2016-05-28','Bar B Q','Chicken Reshmi kabab Seekh',120),(186,'2016-05-28','Bar B Q','Gola kabab Seekh',110),(187,'2016-06-18','Bar B Q','Chicken Tikka (Leg)',160),(188,'2016-07-04','Fast Food','Cole Slaw',30),(189,'2016-07-14','Bar B Q','Chatni',20),(190,'2016-07-20','Bar B Q','Chicken Cheese Roll',130),(191,'2016-09-18','Bar B Q','Koila',80),(192,'2016-12-21','Fast Food','Club Sand With Cheese',180),(193,'2016-12-21','Bar B Q','Crispy Roll With Cheese',180),(194,'2016-12-21','Bar B Q','Reshmi Kabab mayo Cheese Roll',130),(195,'2017-08-09','Karahi','Beef Karahi',1200),(196,'2017-08-09','Karahi','Beef White Karahi',1400),(197,'2017-10-07','Fast Food','Mayo',30);

/*Table structure for table `suppliers` */

DROP TABLE IF EXISTS `suppliers`;

CREATE TABLE `suppliers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `company_name` varchar(225) NOT NULL,
  `full_name` varchar(225) NOT NULL,
  `contact` varchar(225) NOT NULL,
  `address` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;

/*Data for the table `suppliers` */

insert  into `suppliers`(`id`,`date_time`,`company_name`,`full_name`,`contact`,`address`) values (1,'2016-05-09 17:40:28','Fries Factory','Waqas Ahmed','03118169233','Dastageer'),(2,'2016-05-15 20:11:34','Chicken','Shah G','03452396923','Address'),(3,'2016-07-26 02:19:31','Rasheed Aata','Abdul Rashhed','0211111','233000'),(4,'2016-08-07 00:59:16','Total Interior Solution','Sharjeel Saya','03002119323','Address'),(5,'2016-08-07 01:00:05','Electration','Yaseen Contractor','03122918242','Address'),(6,'2016-08-07 01:01:05','Pepsi','Amir Habib','03008293705','Address'),(7,'2016-08-07 01:03:24','Mozato Cheeze','Shakeel Rehman','03008676954','Address'),(8,'2016-08-07 01:04:35','Electronics','Hameed Ali','03212121530','Address'),(9,'2016-08-07 01:09:50','Koila','rustum khan','03002360395','Address'),(10,'2016-08-07 01:12:06','Pots','Iftikhar Bhai','03222283563','Address'),(11,'2016-08-07 01:12:43','Dawn','Qyoom Bhai','03313278870','Address'),(12,'2016-08-07 01:13:26','Printer','Mamoon Bhai','03332193463','Address'),(13,'2016-08-07 01:13:59','Pakola','Pakola Bhai','03002607279','Address'),(14,'2016-08-07 01:14:32','PTCL','Waseem Bhai','03012977199','Address'),(15,'2016-08-07 01:39:36','Italian','Nazim Ghani','03212340480','Address'),(16,'2016-08-08 00:00:14','Water','Salman Bhai','03158696693','Address'),(17,'2016-08-14 01:22:06','Egency','Egency Water','03002956863','Gulshan'),(18,'2017-05-09 01:44:46','Printing','Shabbir Bhai','03332313585','KHI'),(19,'2017-06-12 20:28:29','N.A Traders','N.A Traders','03002252132','Moti Mehl'),(20,'2017-06-22 00:21:10','ELECTRATION PAKKA','mUNEER AHMED','03070212972','gULSHAN'),(21,'2017-06-24 04:00:26','Ice And Cooler','Muneer Ahmed','03132911476','Gulshan'),(22,'2017-07-05 22:46:05','Nestle {Cream Milk }','Salman Khan','03142244543','Godam Chorangi'),(23,'2017-07-08 03:04:38','My Printer','Azeem Bhai','03340373370','Site Area'),(24,'2017-07-23 18:59:01','welding','Ashfaq Bhai','03162035499','New Karachi');

/*Table structure for table `users` */

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) DEFAULT NULL,
  `user_name` varchar(150) DEFAULT NULL,
  `email` varchar(150) DEFAULT NULL,
  `pass` varchar(250) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_name` (`user_name`),
  UNIQUE KEY `unique_email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

/*Data for the table `users` */

insert  into `users`(`id`,`name`,`user_name`,`email`,`pass`,`role_id`,`is_active`) values (1,'Developer','dev','info@webappcare.com','3D801AA532C1CEC3EE82D87A99FDF63F',1,1),(3,'Super Admin','admin','safdarhameed3@gmail.com','d39b6a27c26ae7cff22936dda8dc2ca9',1,1),(4,'Sales','sales','sales@webappcare.com','3d6628f4cb46899d40813923976347c8',3,1);

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
